<?php load_theme_textdomain('miraculous', get_template_directory() . '/languages');
/**
 * Miraculous functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Miraculous
 */

if ( ! function_exists( 'miraculous_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function miraculous_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Miraculous, use a find and replace
		 * to change 'miraculous' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'miraculous', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		 
		add_theme_support( 'post-thumbnails' );
        add_editor_style();
        
		/**
		 * This theme uses wp_nav_menu() in one location.
		 */ 
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary', 'miraculous' ),
			'menu_one' => esc_html__( 'First Menu', 'miraculous' ),
			'menu_middle' => esc_html__( 'Middle Menu', 'miraculous' ),
			'menu_last' => esc_html__( 'Last Menu', 'miraculous' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		/**
		 *Set up the WordPress core custom background feature.
		 */ 
		add_theme_support( 'custom-background', apply_filters( 'miraculous_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		/**
		 * Add theme support for selective refresh for widgets.
		 */ 
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'miraculous_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function miraculous_content_width() {
   /***
    * This variable is intended to be overruled from themes.
    * 
	*Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	*
	*phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	*
	*/
	
	$GLOBALS['content_width'] = apply_filters( 'miraculous_content_width', 640 );
}
add_action( 'after_setup_theme', 'miraculous_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function miraculous_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'miraculous' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add Sidebar Widgets Here.', 'miraculous' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer 1', 'miraculous' ),
		'id'            => 'footer-1',
		'description'   => esc_html__( 'Add Footer Col One Widgets Here.', 'miraculous' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h1 class="footer_title">',
		'after_title'   => '</h1>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer 2', 'miraculous' ),
		'id'            => 'footer-2',
		'description'   => esc_html__( 'Add Footer Col Two Widgets Here.', 'miraculous' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h1 class="footer_title">',
		'after_title'   => '</h1>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer 3', 'miraculous' ),
		'id'            => 'footer-3',
		'description'   => esc_html__( 'Add Footer Col Three Widgets Here.', 'miraculous' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h1 class="footer_title">',
		'after_title'   => '</h1>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer 4', 'miraculous' ),
		'id'            => 'footer-4',
		'description'   => esc_html__( 'Add Footer Col Four Widgets Here.', 'miraculous' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h1 class="footer_title">',
		'after_title'   => '</h1>',
	) );
}
add_action( 'widgets_init', 'miraculous_widgets_init' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/** 
 * Miraculous Function
 */
require get_template_directory() . '/vendor/miraculous-function.php';

/**
 * Theme Option Setting Class
 */
require get_template_directory() . '/vendor/include/miraculous-core-library.php'; 