<?php if (!defined('FW')) die('Forbidden');

$playlist_heading = $mpurl = '';
if(!empty($atts['user_playlist_heading'])):
  $playlist_heading = $atts['user_playlist_heading'];
endif;

$user_id = '';
if(get_current_user_id()):
   $user_id = get_current_user_id();
endif;
$miraculous_theme_data = '';
if (function_exists('fw_get_db_settings_option')):  
    $miraculous_theme_data = fw_get_db_settings_option();     
endif; 
$currency = '';
if(!empty($miraculous_theme_data['paypal_currency']) && function_exists('miraculous_currency_symbol')):
    $currency = miraculous_currency_symbol( $miraculous_theme_data['paypal_currency'] );
endif;
$list_type = 'music';
$close_url = get_template_directory_uri().'/assets/images/svg/close.svg';
$play_icone = get_template_directory_uri().'/assets/images/svg/play.svg';
$more_img = get_template_directory_uri().'/assets/images/svg/more.svg';
$default_playlist_img = get_template_directory_uri().'/assets/images/img13.jpg';
$default_favourite_img = get_template_directory_uri().'/assets/images/img2.jpg';
$playlists = '';

if($user_id):
    
    global $wpdb;
    if(is_multisite()):
        $usermeta_tbl = $wpdb->get_blog_prefix(0) . 'usermeta';
    else:
        $usermeta_tbl = $wpdb->prefix . 'usermeta';
    endif;
    $sql = "SELECT * FROM $usermeta_tbl WHERE `user_id` = $user_id AND `meta_key` LIKE 'miraculous_playlist_%'";
    $playlists = $wpdb->get_results($sql);


if( isset($_GET['do']) && $_GET['do'] != '' ):
    $songs_type = '';
    if('favourites' == $_GET['do']):
        $key = 'favourites_songs_lists'.$user_id;
        $songs_type = 'favourites';
    else:
        $key = 'miraculous_playlist_'.$user_id.'_'.$_GET['do']; 
        $songs_type = $_GET['do'];
    endif;
    $musicsids = get_user_meta($user_id, $key, true); 
?>
<div class="ms_free_download ms_purchase_wrapper">
        <div class="ms_heading">
            <h1><?php echo esc_html( str_replace('-', ' ', $_GET['do']) ); ?></h1>
        </div>
        <div class="album_inner_list">
                <div class="album_list_wrapper">
                    <ul class="album_list_name">
                        <li><?php esc_html_e('#','miraculous'); ?></li>
                        <li><?php esc_html_e('Song Title','miraculous'); ?></li>
                        <li><?php esc_html_e('Artists','miraculous'); ?></li>
                        <li class="text-center"><?php esc_html_e('price','miraculous'); ?></li>
                        <li class="text-center"><?php esc_html_e('Duration','miraculous'); ?></li>
                        <li class="text-center"><?php esc_html_e('More','miraculous'); ?></li>
                        <li class="text-center"><?php esc_html_e('remove','miraculous'); ?></li>
                    </ul>
                   <?php 
                    if($musicsids): 
                    $sg_args = array('post_type' => 'ms-music',
                                     'post__in' => $musicsids,
                                     );
                    $music_posts = new WP_Query( $sg_args );
                    if($music_posts->have_posts()): 
                    $i=1;
                    while ( $music_posts->have_posts() ) : $music_posts->the_post(); 
                    $attach_meta = array();
                    $music_extranal_url = get_post_meta(get_the_id(), 'fw_option:music_extranal_url', true);
                    if(!empty($music_extranal_url)):
                    	$mpurl = $music_extranal_url;
                    else:
                    	$mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                    endif;
                    if($mpurl) {
                        $attach_meta = wp_get_attachment_metadata( $mpurl['attachment_id'] );
                    }
                    $image_uri = get_the_post_thumbnail_url ( get_the_id() );
                    ?>
                    <ul class="ms_list_songs">
                        <li><a href="javascript:;"><span class="play_no"><?php echo (strlen($i) < 2) ? '0'.$i : $i; ?></span><span class="play_hover"></span></a></li>
                        <li><a href="javascript:;" data-musicid="<?php echo esc_attr(get_the_id()); ?>" class="play_single_music"><?php the_title(); ?></a></li>
                        <?php 
                        $artists_name = array(); 
                        $music_price = '';
                        if(function_exists('fw_get_db_post_option')){
                            $artists_ids = fw_get_db_post_option(get_the_id(), 'music_artists'); 
                            foreach ($artists_ids as $artists_id):
                                $artists_name[] = get_the_title($artists_id);
                            endforeach;

                            $music_price_arr = fw_get_db_post_option(get_the_id(), 'music_type_options');
                            if( !empty( $music_price_arr['premium']['single_music_price'] ) ){
                                $music_price = $music_price_arr['premium']['single_music_price'];
                            }
                        }
                    ?>
                    <li><a href="javascript:;" class="play_single_music"><?php echo implode(', ', $artists_name); ?></a></li>
                   <?php if(empty($music_price)): ?>
                           <li class="text-center"><a href="javascript:;"><?php esc_html_e('Free', 'miraculous'); ?></a></li>
                       <?php else: ?>
                           <li class="text-center"><a href="javascript:;"><?php printf( __('%s%s', 'miraculous'), $currency, $music_price ); ?></a></li>
                   <?php endif;
                    ?>
                    <li class="text-center"><a href="javascript:;"><?php echo (isset($attach_meta['length_formatted'])) ? $attach_meta['length_formatted'] : "0.00"; ?></a></li>
                        <li class="text-center ms_more_icon"><a href="javascript:;"><span class="ms_icon1 ms_active_icon"></span></a>
                            <ul class="more_option">
                                <li>
									<a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_html_e(get_the_id()); ?>" data-musictype="<?php esc_html_e($list_type); ?>">
									<span class="opt_icon">
									<span class="icon icon_queue"></span>
									</span>
									<?php esc_html_e('Add To Queue','miraculous'); ?>
									</a>
								</li>
                                <li>
									<a href="javascript:;" class="ms_download" data-msmusic="<?php echo esc_attr(get_the_id()); ?>">
									<span class="opt_icon">
									<span class="icon icon_dwn"></span>
									</span>
									<?php esc_html_e('Download Now','miraculous'); ?>
									</a>
								</li>
                                <li>
									<a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>">
									<span class="opt_icon">
									<span class="icon icon_share"></span>
									</span>
									<?php esc_html_e('Share','miraculous'); ?>
									</a>
								</li>
                            </ul>
                        </li>
                        <?php if(!empty($close_url)): ?>
                           <li class="text-center">
                                <?php if($songs_type == 'favourites'): ?>
    						    <a href="javascript:;" class="remove_favourite_music" musicid="<?php echo esc_attr(get_the_id()); ?>">
                                    <span class="ms_close">
                                        <img src="<?php echo esc_url($close_url); ?>" alt="<?php esc_attr_e('Close', 'miraculous'); ?>">
                                    </span>
    							</a>
                                <?php else: ?>
                                        <a href="javascript:;" class="remove_user_playlist_music" musicid="<?php echo esc_attr(get_the_id()); ?>" data-list="<?php echo esc_attr($songs_type); ?>">
                                            <span class="ms_close">
                                                <img src="<?php echo esc_url($close_url); ?>" alt="<?php esc_attr_e('Close', 'miraculous'); ?>">
                                            </span>
                                        </a>
                                <?php endif; ?>
						   </li>
                        <?php endif; ?>
                        </ul>
                    <?php 
                     $i++;
                     endwhile; 
                     wp_reset_postdata();
                     endif;
                    endif;
                  ?>
                </div>
            </div>
        </div>
<?php else: ?>
<div class="ms_top_artist">
    <div class="container-fluid">
        <div class="row">
            <?php if(!empty($playlist_heading)): ?>
                <div class="col-lg-12">
                    <div class="ms_heading">
                        <h1><?php echo esc_html($playlist_heading); ?></h1>
                    </div>
                </div>
            <?php endif; 
            if(!empty($user_id)): ?>
                <div class="col-lg-4 col-md-6">
                <div class="ms_rcnt_box marger_bottom25">
                    <?php
                    $fav = 'ms_favourite';
                    $key = 'favourites_songs_lists'.$user_id; 
                    $data = miraculous_user_playlist_songs($key);
                    ?>
                    <div class="ms_rcnt_box_img">
                        <?php if(!empty($data['image'])): ?>
                                <img src="<?php echo esc_url($data['image']); ?>" alt="<?php esc_attr_e('song images','miraculous')?>" class="img-fluid">
                        <?php else: ?>
                                <img src="<?php echo esc_url($default_favourite_img); ?>" alt="<?php esc_attr_e('favourite', 'miraculous'); ?>" class="img-fluid">
                        <?php endif; ?>
                        <?php if(!empty($play_icone)): ?>
                            <div class="ms_main_overlay">
                                <div class="ms_box_overlay"></div>
                                 <div class="ms_play_icon play_btn play_list_music" data-list="<?php echo esc_attr($fav); ?>">
                                    <img src="<?php echo esc_url($play_icone); ?>" alt="<?php esc_attr_e('Play', 'miraculous'); ?>">
                                 </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="ms_rcnt_box_text">
                        <h3><a href="<?php echo get_the_permalink(); ?>?do=favourites">
                            <?php esc_html_e('My Favourites', 'miraculous'); ?></a></h3>
                        <p>
                        <?php 
                        $total = '';
                        if(!empty($data['total'])):
                           $total = $data['total'];
                        endif;
                        printf(esc_html__('%s songs', 'miraculous'), $total);
                        ?>
                        </p>
                    </div>
                </div>
            </div>
            <?php endif;
			$i = 1;
            if(!empty($playlists)):
                foreach($playlists as $playlist): ?>
                <div class="col-lg-4 col-md-6">
                    <div class="ms_rcnt_box marger_bottom30">
                        <?php 
                        $key = explode('_', $playlist->meta_key);
                        $name = str_replace('-', ' ', end($key));
                        $data = miraculous_user_playlist_songs($playlist->meta_key);
                        ?>
                        <div class="ms_rcnt_box_img">
                            <?php if(!empty($data['image'])): ?>
                                <img src="<?php echo esc_url($data['image']); ?>" alt="<?php esc_attr_e('song images','miraculous')?>" class="img-fluid">
                            <?php else: ?>
                                <img src="<?php echo esc_url($default_playlist_img); ?>" alt="<?php esc_attr_e('song images','miraculous')?>" class="img-fluid">
                            <?php endif; ?>
                            <div class="ms_main_overlay">
                                <div class="ms_box_overlay"></div>
                                <div class="ms_more_icon">
                                    <img src="<?php echo esc_url($more_img); ?>" alt="<?php echo esc_attr('More', 'miraculous'); ?>">
                                </div>
                                <?php $attach_meta = array();
                                
                                    $music_extranal_url = get_post_meta(get_the_id(), 'fw_option:music_extranal_url', true);
                                    if(!empty($music_extranal_url)):
                                    	$mpurl = $music_extranal_url;
                                    else:
                                    	$mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                                    endif;
                                    
                                    if($mpurl) {
                                        $attach_meta = wp_get_attachment_metadata( $mpurl['attachment_id'] );
                                    }
                                    $image_uri = get_the_post_thumbnail_url ( get_the_id() ); ?>
                                <ul class="more_option">
                                    <li><a href="javascript:;" class="ms_remove_user_playlist" data-list="<?php echo esc_attr(end($key)); ?>"><span class="opt_icon"><span class="icon icon_playlst"></span></span><?php esc_html_e('Remove Playlist', 'miraculous'); ?></a></li>
                                </ul>
                                <div class="ms_play_icon play_btn play_list_music" data-list="<?php echo esc_attr(end($key)); ?>">
                                    <img src="<?php echo esc_url($play_icone); ?>" alt="<?php esc_attr_e('Play','miraculous'); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="ms_rcnt_box_text">
                            <h3><a href="<?php echo get_the_permalink(); ?>?do=<?php echo esc_attr_e(end($key)); ?>"><?php echo esc_html($name); ?></a></h3>
                            <p>
                            <?php 
                            printf( __('%s songs', 'miraculous'), $data['total']); 
                            ?>
                            </p>
                        </div>
                    </div>
                </div>
			
            <?php 
			$i++;
			endforeach;
            endif; ?>
            <div class="col-lg-4">
                <div class="ms_rcnt_box marger_bottom30">
                    <a href="javascript:;" data-toggle="modal" data-target="#create_playlist_modal">
                        <div class="create_playlist">
                            <i class="ms_icon icon_playlist"></i>
                        </div>
                    </a>
                    <div class="ms_rcnt_box_text">
                        <h3><a href="javascript:;"><?php esc_html_e('Create New Playlist','miraculous'); ?></a></h3>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif;
else: ?>
    <script>
        $(document).ready(function(){
           $("#myModal1").modal("show");
        });
    </script>
    <?php
endif;