<?php if (!defined('FW')) die('Forbidden');
$heading = '';
if(!empty($atts['rc_music_label'])):
 $heading = $atts['rc_music_label'];
endif;
$sg_style = 'abstyle1';
if(!empty($atts['rc_music_style'])):
    $sg_style = $atts['rc_music_style'];
endif;
$number_limits = 15;
if(!empty($atts['number_limits'])):
 $number_limits = $atts['number_limits'];
endif;

$more_img = get_template_directory_uri().'/assets/images/svg/more.svg';
$play_img = get_template_directory_uri().'/assets/images/svg/play.svg';

$userid = get_current_user_id();
$music_ids = '';
$music_ids = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);

$fav_music_ids = '';
if($userid):
    $fav_music_ids = get_user_meta($userid, 'favourites_songs_lists'.$userid, true);

    if($music_ids):

        $sg_args = array('post_type' => 'ms-music',
                        'posts_per_page' => $number_limits,
                        'post__in' => $music_ids,
                        'orderby' => 'rand',
                        );
        $music_posts = new WP_Query( $sg_args );
        $list_type = 'music';
        
    if( $music_posts->have_posts() && $music_posts->found_posts > 4 ): 

        if( $sg_style == 'abstyle2' ): ?>
        <!-- Top Artist Section -->
        <div class="ms_top_artist">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="ms_heading">
                                    <h1><?php echo esc_html( $heading ); ?></h1>
                                </div>
                            </div>
                            <?php while ( $music_posts->have_posts() ) : $music_posts->the_post(); ?>
                                <div class="col-lg-2">
                                    <div class="ms_rcnt_box marger_bottom30">
                                        <div class="ms_rcnt_box_img">
                                            <?php the_post_thumbnail( 'large' ); ?>
                                            <div class="ms_main_overlay">
                                                <div class="ms_box_overlay"></div>
                                                <div class="ms_more_icon">
                                                    <img src="<?php echo esc_url($more_img); ?>" alt="<?php esc_attr_e('More', 'miraculous'); ?>">
                                                </div>
                                                <?php $attach_meta = array();
                                                    $music_extranal_url = get_post_meta(get_the_id(), 'fw_option:music_extranal_url', true);
                                                    if(!empty($music_extranal_url)):
                                                    	$mpurl = $music_extranal_url;
                                                    else:
                                                    	$mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                                                    endif;
                                                    if($mpurl) {
                                                        $attach_meta = wp_get_attachment_metadata( $mpurl['attachment_id'] );
                                                    }
                                                    $image_uri = get_the_post_thumbnail_url ( get_the_id() );
                                                    $fav_class = 'icon_fav';
                                                    if(!empty($fav_music_ids)){
                                                        if( in_array(get_the_id(), $fav_music_ids) ) {
                                                            $fav_class = 'icon_fav_add';
                                                        }
                                                    } ?>
                                                <ul class="more_option">
                                                    <li>
                                                      <a href="javascript:;" class="favourite_music" data-musicid="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon <?php echo esc_attr($fav_class); ?>"></span></span><?php esc_html_e('Favourites', 'miraculous'); ?></a>
                                                    </li>
                                                    <li>
                                                      <a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_attr(get_the_id()); ?>" data-musictype="<?php printf($list_type); ?>"><span class="opt_icon"><span class="icon icon_queue"></span></span><?php esc_html_e('Add To Queue', 'miraculous'); ?>
                                                      </a>
                                                    </li>
                                                    <li>
                                                     <a href="javascript:;" class="ms_download" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_dwn"></span></span><?php esc_html_e('Download Now', 'miraculous'); ?>
                                                     </a>
                                                    </li>
                                                    <li>
                                                      <a href="javascript:;" class="ms_add_playlist" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_playlst"></span></span>
                                                      <?php esc_html_e('Add To Playlist', 'miraculous'); ?>
                                                      </a>
                                                    </li>
                                                    <li>
                                                      <a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>"><span class="opt_icon"><span class="icon icon_share"></span></span>
                                                      <?php esc_html_e('Share', 'miraculous'); ?>
                                                      </a>
                                                    </li>
                                                    <li>
                                                      <a href="javascript:;" class="ms_remove_history_music" data-musicid="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_close"></span></span>
                                                      <?php esc_html_e('Remove', 'miraculous'); ?>
                                                      </a>
                                                    </li>
                                                </ul>
                                                <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_attr_e(get_the_id()); ?>" data-musictype="<?php printf($list_type); ?>">
                                                    <img src="<?php echo esc_url($play_img); ?>" alt="<?php  esc_attr_e('Play', 'miraculous'); ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="ms_rcnt_box_text">
                                            <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
                                            <?php $artists_name = array(); $artists_ids = fw_get_db_post_option(get_the_id(), 'music_artists'); 
                                            foreach ($artists_ids as $artists_id) {
                                                 $artists_name[] = get_the_title($artists_id);
                                             } ?>
                                            <p><?php echo implode(', ', $artists_name); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                            <?php wp_reset_postdata(); ?>
                        </div>
                    </div>
                </div>
         <?php endif;
        if( $sg_style == 'abstyle1' ): ?>
            <div class="ms_fea_album_slider">
                <div class="ms_heading">
                    <h1><?php echo esc_html( $heading ); ?></h1>
                </div>
                <div class="ms_relative_inner">
                    <div class="ms_feature_slider swiper-container swiper-container-horizontal">
                        <div class="swiper-wrapper">
                            <?php 
                            $i=0;
                            while ( $music_posts->have_posts() ) : $music_posts->the_post(); ?>
                            <div class="swiper-slide<?php echo ($i==0) ? ' swiper-slide-active' : '';?>" data-swiper-slide-index="<?php echo _e($i); ?>">
                                    <div class="ms_rcnt_box">
                                        <div class="ms_rcnt_box_img">
                                            <?php the_post_thumbnail( 'large' ); ?>
                                            <div class="ms_main_overlay">
                                                <div class="ms_box_overlay"></div>
                                                <div class="ms_more_icon">
                                                    <img src="<?php echo esc_url($more_img); ?>" alt="<?php echo esc_attr('More', 'miraculous'); ?>">
                                                </div>
                                                <?php $attach_meta = array();
                                                    $music_extranal_url = get_post_meta(get_the_id(), 'fw_option:music_extranal_url', true);
                                                    if(!empty($music_extranal_url)):
                                                    	$mpurl = $music_extranal_url;
                                                    else:
                                                    	$mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                                                    endif;
                                                    if($mpurl) {
                                                        $attach_meta = wp_get_attachment_metadata( $mpurl['attachment_id'] );
                                                    }
                                                    $image_uri = get_the_post_thumbnail_url ( get_the_id() );
                                                    $fav_class = 'icon_fav';
                                                    if(!empty($fav_music_ids)){
                                                        if( in_array(get_the_id(), $fav_music_ids) ) {
                                                            $fav_class = 'icon_fav_add';
                                                        } 
                                                    } ?>
                                                <ul class="more_option">
                                                    <li><a href="javascript:;" class="favourite_music" data-musicid="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon <?php echo esc_attr($fav_class); ?>"></span></span><?php esc_html_e('Favourites', 'miraculous'); ?></a></li>
                                                    <li><a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_attr_e(get_the_id()); ?>" data-musictype="<?php printf($list_type); ?>"><span class="opt_icon"><span class="icon icon_queue"></span></span><?php esc_html_e('Add To Queue', 'miraculous'); ?></a></li>
                                                    <li><a href="javascript:;" class="ms_download" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_dwn"></span></span><?php esc_html_e('Download Now', 'miraculous'); ?></a></li>
                                                    <li><a href="javascript:;" class="ms_add_playlist" data-msmusic="<?php echo esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_playlst"></span></span><?php esc_html_e('Add To Playlist', 'miraculous'); ?></a></li>
                                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>"><span class="opt_icon"><span class="icon icon_share"></span></span><?php esc_html_e('Share', 'miraculous'); ?></a></li>
                                                </ul>
                                                <div class="ms_play_icon play_btn play_music" data-musicid="<?php esc_attr_e(get_the_id()); ?>" data-musictype="<?php printf($list_type); ?>">
                                                    <img src="<?php echo esc_url($play_img); ?>" alt="<?php  esc_attr_e('play', 'miraculous'); ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="ms_rcnt_box_text">
                                            <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
                                            <?php $artists_name = array(); $artists_ids = fw_get_db_post_option(get_the_id(), 'music_artists'); 
                                            foreach ($artists_ids as $artists_id) {
                                                 $artists_name[] = get_the_title($artists_id);
                                             } ?>
                                            <p><?php echo implode(', ', $artists_name); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php $i++; 
                            endwhile;
                            wp_reset_postdata(); ?>
                        </div> 
                        <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
                        <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
                    </div>
                    <!-- Add Arrows -->
                    <div class="swiper-button-next1 slider_nav_next" tabindex="0" role="button" aria-label="<?php esc_attr_e('Next slide','miraculous'); ?>"></div>
                    <div class="swiper-button-prev1 slider_nav_prev" tabindex="0" role="button" aria-label="<?php esc_attr_e('Previous slide','miraculous'); ?>"></div>
                </div>
            </div>
        <?php endif;
        endif;
    endif;
endif;