<?php
/**
 * Plugin Name: Custom Post API
 * Plugin URI: https://example.com
 * Description: A custom API to handle direct database post creation.
 * Version: 1.0
 * Author: Your Name
 * Author URI: https://example.com
 */

// Register the custom API route
add_action('rest_api_init', function () {
    register_rest_route('custom/v1', '/post', [
        'methods' => 'POST',
        'callback' => 'handle_custom_post_request',
        'permission_callback' => '__return_true',

    ]);
});

function handle_custom_post_request(WP_REST_Request $request)
{
    global $wpdb;
    $payload = $request->get_json_params();

    // Validate required fields
    if (!isset($payload['post_title'])) {
        return new WP_REST_Response(['message' => 'Missing required fields.'], 400);
    }

    $post_title = sanitize_text_field($payload['post_title']);
    
    // Check if a post with the same title already exists
    $existing_post = $wpdb->get_var($wpdb->prepare(
        "SELECT ID FROM {$wpdb->posts} WHERE post_title = %s AND post_type = 'ms-music'",
        $post_title
    ));

    // If a post with the same title exists, return an error
    if ($existing_post) {
        return new WP_REST_Response(['message' => 'A post with this title already exists.'], 400);
    }

    // Determine the next post ID
    $last_post_id = $wpdb->get_var("SELECT MAX(ID) FROM {$wpdb->posts}");
    $next_post_id = $last_post_id ? $last_post_id + 1 : 1;

    // Prepare data for insertion
    $post_name = sanitize_title($post_title);

    $data = [
        'ID' => $next_post_id,
        'post_author' => 17,
        'post_date' => '2025-01-01 18:09:20',
        'post_date_gmt' => '2025-01-01 14:39:20',
        'post_title' => $post_title,
        'post_status' => 'publish',
        'comment_status' => 'closed',
        'post_name' => $post_name,
        'post_modified' => '2025-01-01 18:09:20',
        'post_modified_gmt' => '2025-01-01 14:39:20',
        'post_parent' => 0,
        'guid' => "https://mahomusic.ir/?post_type=ms-music&#038;p=2522",
        'menu_order' => 0,
        'post_type' => 'ms-music',
        'comment_count' => 0
    ];

    // Insert data into the database
    $inserted = $wpdb->insert($wpdb->posts, $data);

    if ($inserted === false) {
        return new WP_REST_Response(['message' => 'Error inserting post into database.', 'error' => $wpdb->last_error], 500);
    }

    return new WP_REST_Response(['message' => 'Post successfully created.', 'post_id' => $next_post_id], 200);
}