<?php
/**
 * miraculous class of ajax function
 */

class Miraculous_Ajax_Call{

  public function __construct() {

     /* */

	}
 
   public function init(){

		add_action( 'wp_ajax_miraculous_create_new_user_playlist', array( $this, 'miraculous_create_new_user_playlist' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_create_new_user_playlist', array( $this, 'miraculous_create_new_user_playlist' ), 10 );



		add_action( 'wp_ajax_miraculous_user_login_form', array( $this, 'miraculous_user_login_form' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_login_form', array( $this, 'miraculous_user_login_form' ), 10 );



		add_action( 'wp_ajax_miraculous_user_register_form', array( $this, 'miraculous_user_register_form' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_register_form', array( $this, 'miraculous_user_register_form' ), 10 );



		add_action( 'wp_ajax_miraculous_user_update_form', array( $this, 'miraculous_user_update_form' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_update_form', array( $this, 'miraculous_user_update_form' ), 10 );



		add_action( 'wp_ajax_miraculous_user_newsletter_form', array( $this, 'miraculous_user_newsletter_form' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_newsletter_form', array( $this, 'miraculous_user_newsletter_form' ), 10 );



		add_action( 'wp_ajax_miraculous_add_in_favourites_songs_list', array( $this, 'miraculous_add_in_favourites_songs_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_in_favourites_songs_list', array( $this, 'miraculous_add_in_favourites_songs_list' ), 10 );



		add_action( 'wp_ajax_miraculous_remove_from_favourites_songs_list', array( $this, 'miraculous_remove_from_favourites_songs_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_from_favourites_songs_list', array( $this, 'miraculous_remove_from_favourites_songs_list' ), 10 );



		add_action( 'wp_ajax_miraculous_add_in_favourites_albums_list', array( $this, 'miraculous_add_in_favourites_albums_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_in_favourites_albums_list', array( $this, 'miraculous_add_in_favourites_albums_list' ), 10 );



		add_action( 'wp_ajax_miraculous_add_in_favourites_radios_list', array( $this, 'miraculous_add_in_favourites_radios_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_in_favourites_radios_list', array( $this, 'miraculous_add_in_favourites_radios_list' ), 10 );



		add_action( 'wp_ajax_miraculous_add_in_favourites_artists_list', array( $this, 'miraculous_add_in_favourites_artists_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_in_favourites_artists_list', array( $this, 'miraculous_add_in_favourites_artists_list' ), 10 );



		add_action( 'wp_ajax_miraculous_add_music_in_user_playlist', array( $this, 'miraculous_add_music_in_user_playlist' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_music_in_user_playlist', array( $this, 'miraculous_add_music_in_user_playlist' ), 10 );



		add_action( 'wp_ajax_miraculous_filter_music_language', array( $this, 'miraculous_filter_music_language' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_filter_music_language', array( $this, 'miraculous_filter_music_language' ), 10 );



		add_action( 'wp_ajax_miraculous_user_music_upload', array( $this, 'miraculous_user_music_upload' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_music_upload', array( $this, 'miraculous_user_music_upload' ), 10 );



		add_action( 'wp_ajax_miraculous_music_download', array( $this, 'miraculous_music_download' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_music_download', array( $this, 'miraculous_music_download' ), 10 );


		add_action( 'wp_ajax_miraculous_remove_from_premium_songs_list', array( $this, 'miraculous_remove_from_premium_songs_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_from_premium_songs_list', array( $this, 'miraculous_remove_from_premium_songs_list' ), 10 );


		add_action( 'wp_ajax_miraculous_remove_from_free_songs_list', array( $this, 'miraculous_remove_from_free_songs_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_from_free_songs_list', array( $this, 'miraculous_remove_from_free_songs_list' ), 10 );


		add_action( 'wp_ajax_miraculous_remove_from_user_playlist_songs_list', array( $this, 'miraculous_remove_from_user_playlist_songs_list' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_from_user_playlist_songs_list', array( $this, 'miraculous_remove_from_user_playlist_songs_list' ), 10 );


		add_action( 'wp_ajax_miraculous_add_to_queue_action', array( $this, 'miraculous_add_to_queue_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_add_to_queue_action', array( $this, 'miraculous_add_to_queue_action' ), 10 );

		add_action( 'wp_ajax_miraculous_play_all_music_action', array( $this, 'miraculous_play_all_music_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_play_all_music_action', array( $this, 'miraculous_play_all_music_action' ), 10 );
		
		add_action( 'wp_ajax_miraculous_remove_user_playlist', array( $this, 'miraculous_remove_user_playlist' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_user_playlist', array( $this, 'miraculous_remove_user_playlist' ), 10 );
		
		add_action( 'wp_ajax_miraculous_play_user_playlist', array( $this, 'miraculous_play_user_playlist' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_play_user_playlist', array( $this, 'miraculous_play_user_playlist' ), 10 );

		add_action( 'wp_ajax_miraculous_user_queue_data_action', array( $this, 'miraculous_user_queue_data_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_queue_data_action', array( $this, 'miraculous_user_queue_data_action' ), 10 );

		add_action( 'wp_ajax_miraculous_user_load_queue_data_action', array( $this, 'miraculous_user_load_queue_data_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_user_load_queue_data_action', array( $this, 'miraculous_user_load_queue_data_action' ), 10 );

		add_action( 'wp_ajax_miraculous_play_single_music_action', array( $this, 'miraculous_play_single_music_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_play_single_music_action', array( $this, 'miraculous_play_single_music_action' ), 10 );

		add_action( 'wp_ajax_miraculous_remove_history_music_action', array( $this, 'miraculous_remove_history_music_action' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_remove_history_music_action', array( $this, 'miraculous_remove_history_music_action' ), 10 );
		
		add_action( 'wp_ajax_miraculous_freeplane_optionajax', array( $this, 'miraculous_freeplane_optionajax' ), 10 );

		add_action( 'wp_ajax_nopriv_miraculous_freeplane_optionajax', array( $this, 'miraculous_freeplane_optionajax' ), 10 );
		
		
	}

    public function miraculous_create_new_user_playlist(){

		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['playlistname']) && $userid) {

		    $p_name = str_replace(' ', '-', $_POST['playlistname']);

		    $key_prefix = "miraculous_playlist_".$userid."_".$p_name;

		    if( get_user_meta($userid, $key_prefix, true) ){

		        $message['status'] = esc_html__('error','miraculous');

		        $message['msg'] = esc_html__('Playlist alreay created with this name.','miraculous');

		    }else{

		        add_user_meta($userid, $key_prefix, '');

		        $message['status'] = esc_html__('success','miraculous');

		        $message['msg'] = esc_html__('Playlist created successfully.','miraculous');

		    }

		    echo json_encode($message);

		    die();

		}



		$message['status'] = esc_html__('error','miraculous');

		$message['msg'] = esc_html__('You need to login.','miraculous');

		echo json_encode($message);

		die();

	}
	
	
	
	public function miraculous_remove_user_playlist(){
	    $message = array();

		$userid = get_current_user_id();

		if (isset($_POST['playlist']) && $userid) {

	    	$playlist_key = 'miraculous_playlist_'.$userid.'_'.$_POST['playlist']; 
            
            $del = delete_user_meta($userid, $playlist_key);
            if($del){
                $message['status'] = esc_html__('success','miraculous');
		        $message['msg'] = esc_html__('Removed Successfully','miraculous');
            }else{
                $message['status'] = esc_html__('error','miraculous');
		        $message['msg'] = esc_html__('Something went wrong.','miraculous');
            }
	    	echo json_encode($message);
	    	die();

		}

		$message['status'] = esc_html__('error','miraculous');
		$message['msg'] = esc_html__('Something went wrong.','miraculous');

		echo json_encode($message);

		die();
	}

	public function miraculous_user_login_form(){

		if( isset($_POST['username']) && isset($_POST['password']) ) {

           extract($_POST);
           
           if($rem_check) {
                $rem = true;
            }else{
                $rem = false;
            }

            if( is_user_logged_in() ) {

				$data = array('status' => 'false', 'msg' => 'You are already logged in!');

			}else{

				$creds = array();

				$creds['user_login'] = $username;

				$creds['user_password'] = $password;

				$creds['remember'] = $rem;

				$user = wp_signon( $creds, true );

				if ( is_wp_error($user) ) {

					$error = esc_html__('Incorrect login details.', 'miraculous');

					$data = array('status' => 'false', 'msg' => $error);

				}else{

					$url = site_url('/');

					$data = array('status' => 'true', 'msg' => 'Login Successfully', 'redirect_uri' => $url);

				}

			}

            echo json_encode($data);

			die();

		}

		$data = array('status' => 'false', 'msg' => 'Something went wrong. Please try again.');

		echo json_encode($data);

		die();

	}



	public function miraculous_user_register_form() {

		$error = array();

		if( isset($_POST['username']) && isset($_POST['full_name']) && isset($_POST['useremail']) && isset($_POST['password']) && isset($_POST['confirmpass']) ) {

			extract($_POST);
            
            if( ! validate_username($username) ) {
		    	$error['erroruser'] = "* Username is not valid. Use only lowercase letter!";
		    }

		    if( username_exists($username) ) {
		    	$error['erroruser'] = "* Username is already exist!";
		    }

		    if( email_exists($useremail) ) {
		    	$error['erroremail'] = "* Email is already exist!"; 
		    }

		    if( empty($error) ) {
				$userdata = array(

					'user_login' => $username,

					'user_pass' => $password,

					'first_name' => $full_name,

					'user_email' => $useremail

				);

		    	$user_id = wp_insert_user( $userdata );

		    	//On success

		    	if ( ! is_wp_error( $user_id ) ) {

					$data = array('status' => 'true', 'msg' => 'You are successfully registered. Please login');

					echo json_encode($data);

		    	}else{

			        $data = array('status' => 'false', 'msg' => 'Something went wrong. Please try again.');
			        echo json_encode($data);
		    	}

		    }else{

				$error['status'] = 'false';
				echo json_encode($error);

		    }
			die();
		}

	}

	public function miraculous_user_update_form() {

		$error = array();

		if( isset($_POST['username']) && isset($_POST['useremail']) && isset($_POST['userid']) ) {

	    	extract($_POST);
	    	$current_user = wp_get_current_user();

		    if( $current_user->user_email != trim($useremail) ) {

		        if( email_exists($useremail) ) {

		            $error['status'] = 'false';

		            $error['msg'] = "Email is already exist!";

		        }

		    }

		    $full_name = explode(' ', $username);

		    $first_name = $full_name[0];

		    unset($full_name[0]);

		    $last_name = implode(' ', $full_name);

            if( empty($error) ) {

               if( isset($password) && isset($confpassword) && $password != '' && $confpassword != '' ) {

		            $userdata = array(

		              'ID' => $userid,

		              'user_pass' => $password,

		              'first_name' => $first_name,

		              'last_name' => $last_name,

		              'user_email' => $useremail,

		              'display_name' => $username

		            );

		        }else{

		            $userdata = array(

		              'ID' => $userid,

		              'first_name' => $first_name,

		              'last_name' => $last_name,

		              'user_email' => $useremail,

		              'display_name' => $username

		            );

		        }

                $user_id = wp_update_user( $userdata );
               //On success
                if (!is_wp_error($user_id)) {
		          update_user_meta($user_id, 'user_profile_img', $profile_img);
                  $data = array('status' => 'true', 'msg' => 'Profile Successfully update');
                  echo json_encode($data);
                }else{
                  $data = array('status' => 'false', 'msg' => 'Something went wrong. Please try again.');
                  echo json_encode($data);
                }

		    }else{
             echo json_encode($error);
            }

           die();

		}

	}

	public function miraculous_user_newsletter_form() {
        
        $message = array();
        if(isset($_POST['ns_email'])){
            
            $fname = $_POST['ns_name'];
            $email = $_POST['ns_email'];
            
            if(!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL) === false){

				// MailChimp API credentials

				$apiKey = '';

				$listID = '';

	        	if( function_exists('fw_get_db_settings_option') ) {

		        	$apiKey = fw_get_db_settings_option( 'mailchimp_api_key' );

		        	$listID = fw_get_db_settings_option( 'mailchimp_list_id' );

	        	}

	         	// MailChimp API URL

				$memberID = md5(strtolower($email));

				$dataCenter = substr($apiKey,strpos($apiKey,'-')+1);

				$url = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/lists/' . $listID . '/members/' . $memberID;

	           // member information

				$json = json_encode([

					'email_address' => $email,

					'status'        => 'subscribed',

					'merge_fields'  => [

						'FNAME'     => $fname

					]

				]);

	           // send a HTTP POST request with curl

				$ch = curl_init($url);

				curl_setopt($ch, CURLOPT_USERPWD, 'user:' . $apiKey);

				curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

				curl_setopt($ch, CURLOPT_TIMEOUT, 10);

				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');

				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

				curl_setopt($ch, CURLOPT_POSTFIELDS, $json);

				$result = curl_exec($ch);

				$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

				curl_close($ch);

	           // store the status message based on response code

	        	if ($httpCode == 200) {

	            	$message['msg'] = esc_html__('You have successfully subscribed.','miraculous');

	            	$message['status'] = esc_html__('success','miraculous');

	        	} else {

	            	switch ($httpCode) {

	                  	case 214:

	                    	$msg = esc_html__('You are already subscribed.','miraculous');

	                    	$message['status'] = esc_html__('success','miraculous');

	                    	break;

	                  	default:

	                    	$msg = esc_html__('Some problem occurred, please try again.','miraculous');

	                    	$message['status'] = esc_html__('error','miraculous');

	                    	break;

	            	}

	              $message['msg'] = $msg;

	        	}

	    	}else{

	        	$message['msg'] = esc_html__('Please enter email address.','miraculous');

	        	$message['status'] = esc_html__('error','miraculous');

	    	}
          
          	echo json_encode($message);

	    	die();

		}

        $message['msg'] = esc_html__('Please enter email address.','miraculous');

		$message['status'] = esc_html__('error','miraculous');

		echo json_encode($message);
        
        die();

	}



	public function miraculous_add_in_favourites_songs_list() {

		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['songid']) && $userid) {

			$songs = array();

			$songs[] = $_POST['songid'];

			$music_id = get_user_meta($userid, 'favourites_songs_lists'.$userid, true);

		    if( $music_id ) {

		    	if( in_array($_POST['songid'], $music_id) ) {
                    $key = array_search($_POST['songid'], $music_id); 
	        		unset($music_id[$key]);
	        		$new_arr = array_values($music_id);
	        		update_user_meta($userid, 'favourites_songs_lists'.$userid, $new_arr);
	        		
			        $message['status'] = esc_html__('success','miraculous');
                    $message['action'] = esc_html__('removed','miraculous');
			        $message['msg'] = esc_html__('Removed successfully','miraculous');

		      	}else{
			        $new_arr = array_merge($music_id, $songs);
			        update_user_meta($userid, 'favourites_songs_lists'.$userid, $new_arr);

			        $message['status'] = esc_html__('success','miraculous');
                    $message['action'] = esc_html__('added','miraculous');
			        $message['msg'] = esc_html__('Added successfully','miraculous');
		      	}

		    }else{

				update_user_meta($userid, 'favourites_songs_lists'.$userid, $songs);
                $message['status'] = esc_html__('success','miraculous');
                $message['msg'] = esc_html__('Added successfully','miraculous');

		    }
        echo json_encode($message);
        die();

		}
        
        $message['status'] = esc_html__('error','miraculous');
        $message['msg'] = esc_html__('You need to login.','miraculous');
        echo json_encode($message);
        die();

	}

   public function miraculous_remove_from_favourites_songs_list(){

		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['songid']) && $userid) {

	    	$songs = array();
            $songs[] = $_POST['songid'];
            $music_id = get_user_meta($userid, 'favourites_songs_lists'.$userid, true);

          if( $music_id ) {

	      		if( in_array($_POST['songid'], $music_id) ) {

	        		$key = array_search($_POST['songid'], $music_id); 

                    unset($music_id[$key]);

	        		$new_arr = array_values($music_id);

	        		update_user_meta($userid, 'favourites_songs_lists'.$userid, $new_arr);

                    $message['status'] = 'success';
                    $message['msg'] = 'Removed successfully';

	      		}

	    	}

          echo json_encode($message);
          die();

		}

        $message['status'] = esc_html__('error','miraculous');
        $message['msg'] = esc_html__('You need to login.','miraculous');
        echo json_encode($message);
        die();

	}


	public function miraculous_add_in_favourites_albums_list(){

	    $message = array();

	    $userid = get_current_user_id();

	    if (isset($_POST['albumid']) && $userid) {

	        $albums = array();

	        $albums[] = $_POST['albumid'];

	        $album_id = get_user_meta($userid, 'favourites_albums_lists'.$userid, true);

	    	if( $album_id ) {

	        	if( in_array($_POST['albumid'], $album_id) ) {
	        	    $key = array_search($_POST['albumid'], $album_id); 

	        		unset($album_id[$key]);
	        		$new_arr = array_values($album_id);

	        		update_user_meta($userid, 'favourites_albums_lists'.$userid, $new_arr);

	          		$message['status'] = esc_html__('success','miraculous');
	          		$message['action'] = esc_html__('removed','miraculous');
	          		$message['msg'] = esc_html__('Removed successfully','miraculous');

	        	}else{

		          	$new_arr = array_merge($album_id, $albums);

		          	update_user_meta($userid, 'favourites_albums_lists'.$userid, $new_arr);

		          	$message['status'] = esc_html__('success','miraculous');
                    $message['action'] = esc_html__('added','miraculous');
		          	$message['msg'] = esc_html__('Added successfully','miraculous');

	        	}

	      	}else{

		        update_user_meta($userid, 'favourites_albums_lists'.$userid, $albums);

		        $message['status'] =esc_html__('success','miraculous');

		        $message['msg'] = esc_html__('Added successfully','miraculous');

	      	}



		    echo json_encode($message);

		    die();

	    }
        $message['status'] = esc_html__('error','miraculous');

	    $message['msg'] = esc_html__('You need to login.','miraculous');

	    echo json_encode($message);

	    die();

	}

	public function miraculous_add_in_favourites_radios_list(){
	    
		$message = array();

	    $userid = get_current_user_id();

	    if (isset($_POST['radioid']) && $userid) {

	        $radios = array();

	        $radios[] = $_POST['radioid'];

	        $radio_id = get_user_meta($userid, 'favourites_radios_lists'.$userid, true);

            if( $radio_id ) {

	        	if( in_array($_POST['radioid'], $radio_id) ) {

	          		$key = array_search($_POST['radioid'], $radio_id); 

	        		unset($radio_id[$key]);
	        		$new_arr = array_values($radio_id);

	        		update_user_meta($userid, 'favourites_radios_lists'.$userid, $new_arr);
                    $message['status'] = esc_html__('success','miraculous');
	          		$message['action'] = esc_html__('removed','miraculous');
	          		$message['msg'] = esc_html__('Removed successfully','miraculous');

	        	}else{

    	          	$new_arr = array_merge($radio_id, $radios);
                    update_user_meta($userid, 'favourites_radios_lists'.$userid, $new_arr);
                    $message['status'] = esc_html__('success','miraculous');
                    $message['msg'] = esc_html__('Added successfully','miraculous');
                }

            }else{

		    update_user_meta($userid, 'favourites_radios_lists'.$userid, $radios);
            $message['status'] = esc_html__('success','miraculous');
            $message['msg'] = esc_html__('Added successfully','miraculous');

	      	}

		    echo json_encode($message);
            die();

	    }

        $message['status'] = esc_html__('error','miraculous');
  	    $message['msg'] = esc_html__('You need to login.','miraculous');
        echo json_encode($message);
        die();
	}

	public function miraculous_add_in_favourites_artists_list(){

	    $message = array();

	    $userid = get_current_user_id();

	    if (isset($_POST['artistid']) && $userid) {

	        $artists = array();

            $artists[] = $_POST['artistid'];

	        $artist_id = get_user_meta($userid, 'favourites_artists_lists'.$userid, true);

      if( $artist_id ) {

	    if( in_array($_POST['artistid'], $artist_id) ) {

		    $key = array_search($_POST['artistid'], $artist_id); 
            unset($artist_id[$key]);
    		$new_arr = array_values($artist_id);
            update_user_meta($userid, 'favourites_artists_lists'.$userid, $new_arr);
            $message['status'] = esc_html__('success','miraculous');
      		$message['action'] = esc_html__('removed','miraculous');
      		$message['msg'] = esc_html__('Removed successfully','miraculous');

	     }else{

		 $new_arr = array_merge($artist_id, $artists);
         update_user_meta($userid, 'favourites_artists_lists'.$userid, $new_arr);
         $message['status'] = esc_html__('success','miraculous');
         $message['msg'] = esc_html__('Added successfully','miraculous');

	     }
        }else{
            update_user_meta($userid, 'favourites_artists_lists'.$userid, $artists);
            $message['status'] = esc_html__('success','miraculous');
            $message['msg'] = esc_html__('Added successfully','miraculous');
          }
          echo json_encode($message);
          die();
        }
        $message['status'] = esc_html__('error','miraculous');
        $message['msg'] = esc_html__('You need to login.','miraculous');
        echo json_encode($message);
        die();
    }

    public function miraculous_add_music_in_user_playlist(){

	    $message = array();

	    $userid = get_current_user_id();

	    if (isset($_POST['musicid']) && isset($_POST['key']) && $userid) {

	        $songs = array();

	        $key = $_POST['key'];

	        $songs[] = $_POST['musicid'];

	        $music_id = get_user_meta($userid, $key, true);



	        if( $music_id ) {

	          	if( in_array($_POST['musicid'], $music_id) ) {

		            $message['status'] = esc_html__('success','miraculous');

		            $message['msg'] =esc_html__('Already added','miraculous');

	          	}else{

		            $new_arr = array_merge($music_id, $songs);

		            update_user_meta($userid, $key, $new_arr);

		            $message['status'] = esc_html__('success','miraculous');

		            $message['msg'] = esc_html__('Added successfully','miraculous');

	          	}

	          

	        }else{

	          	update_user_meta($userid, $key, $songs);

	          	$message['status'] = esc_html__('success','miraculous');

	          	$message['msg'] = esc_html__('Added successfully','miraculous');

	        }



	        echo json_encode($message);

	        die();

	    }



	    $message['status'] = esc_html__('error','miraculous');

	    $message['msg'] = esc_html__('You need to login.','miraculous');

	    echo json_encode($message);

	    die();

	}



	public function miraculous_filter_music_language() {



	    if( isset($_POST['filter_lang']) ) {



	        if( is_user_logged_in() ){

	            $user_id = get_current_user_id();



	            if( $_POST['filter_lang'] != '' ){

	                $lang_data = explode(',', $_POST['filter_lang']);

	                update_option('language_filter_ids_'.$user_id, $lang_data);

	                echo site_url();

	            }else{

	                update_option('language_filter_ids_'.$user_id, $lang_data);

	                echo site_url();

	            }

	        }else{

	            if( $_POST['filter_lang'] != '' ) {

	                $cookie_name = "lang_filter";

	                $cookie_value = $_POST['filter_lang'];

	                setcookie($cookie_name, $cookie_value, time() + (86400 * 30), "/"); // 86400 = 1 day



	                echo site_url();

	            }else{

	                $cookie_name = "lang_filter";

	                $cookie_value = $_POST['filter_lang'];

	                setcookie($cookie_name, $cookie_value, time() + (86400 * 30), "/"); // 86400 = 1 day



	                echo site_url();

	            }

	        }



	    }



	    die();

	}



	public function miraculous_user_music_upload(){

        $miraculous_theme_data = '';
        if (function_exists('fw_get_db_settings_option')):  
          $miraculous_theme_data = fw_get_db_settings_option();     
        endif; 
        $track_page = '';
        if(!empty($miraculous_theme_data['user_blog_page'])):
         $track_page = get_the_permalink( $miraculous_theme_data['user_blog_page'] );
        endif;
        $data = array('status' => 'false', 'msg' => 'Something went Wrong.');

		if( isset($_POST['mp3_url']) ){

		    extract($_POST);

		    $artist_arr = array();

		    $user_id = get_current_user_id();

		    $lang_arr = array( $language_id );

		    if($language_id){

		        $m_args = array(

		            'post_type' => 'ms-music',

		            'post_title' => $track_name,

		            'post_author' => $user_id,

		            'post_status' => $privacy

		      );

		    }else{

		      	$m_args = array(

					'post_type' => 'ms-music',

					'post_title' => $track_name,

					'post_author' => $user_id,

					'post_status' => $privacy

		    	);

		    }

            $music_id =  wp_insert_post($m_args);

	    	if($music_id){

				$artist_arr[] = $_POST['artists_name'];

				$new_full_track = array('attachment_id' => $track_mp3_id, 'url' => $mp3_url);

				update_post_meta($music_id, 'music_added_by', $user_id);

				update_post_meta($music_id, 'fw_option:mp3_full_songs', $new_full_track);

				update_post_meta($music_id, 'mp3_full_songs', $full_track);

				update_post_meta($music_id, 'fw_option:music_artists', $artist_arr);

				update_post_meta($music_id, 'fw_option:music_type', 'free');

	    		if($music_image){

	        		set_post_thumbnail( $music_id, $attachimage_id );
	        		wp_set_post_terms( $music_id, $lang_arr, 'language' );

	      		}

	      		global $wpdb;

	      		$pmt_tbl = $wpdb->prefix . 'ms_payments'; 

	      		$query = $wpdb->get_row( "SELECT * FROM `$pmt_tbl` WHERE user_id = $user_id AND expiretime > '$today'" );

	      		if($query->remains_upload > 0){

		          	$wpdb->update( 

		            	$pmt_tbl, 

			            array( 

			                'remains_upload' => $query->remains_upload-1

			               ), 

		            	array( 'ID' => $query->id ), 

			            array( 

			              '%d'

			            ), 

		            	array( '%d' ) 

		          	);

	      		}

	      		$data = array('status' => 'true', 'msg' => 'Uploaded Successfully.', 'track_page' => $track_page);

	    	}else{

	      		$data = array('status' => 'false', 'msg' => 'Something went Wrong.');

	    	}

	    	echo json_encode($data);

	    	die();

		}

	  	echo json_encode($data);

	  	die();

	}


public function miraculous_music_download(){
	
        $miraculous_theme_data = '';
        if (function_exists('fw_get_db_settings_option')):  
          $miraculous_theme_data = fw_get_db_settings_option();     
        endif; 
        $counte = 1;
        $dowenloadsong = get_post_meta($songid,'song_dowenload_counter',true);
	    if($dowenloadsong):
         $counte +=$dowenloadsong;
        endif;
		$freedowenload = '';
		if(!empty($miraculous_theme_data['directedowenload_switch'])):
		 $freedowenload = $miraculous_theme_data['directedowenload_switch'];
		endif; 
		if($freedowenload == 'on'):
		  $message = array();
	      global $wpdb;
		  if(isset($_POST['musicid'])):
		        $songs = array();
				$songs[] = $_POST['musicid'];
				$mpurl = get_post_meta($_POST['musicid'], 'fw_option:mp3_full_songs', true);
				if(empty($mpurl)):
			    /**
                 * Get meta setting data
                 */
                $miraculous_meta_data = '';
                if (function_exists('fw_get_db_post_option')): 
                  $miraculous_meta_data = fw_get_db_post_option($_POST['musicid']);   
                endif;
                if(!empty($miraculous_meta_data['music_extranal_url'])):
		          $mpurl = $miraculous_meta_data['music_extranal_url'];
		        endif;
				endif;
				$title = get_the_title( $_POST['musicid'] );
				$mp3url = '';
				if($mpurl) {
				   $mp3url = $mpurl['url'];
				}
			  $message['status'] = esc_html__('success','miraculous');
              $message['msg'] = esc_html__('Already downloaded','miraculous');
    		  $message['mp3_uri'] = $mp3url;
    		  $message['mp3_name'] = $title;
    		  
		  endif;
		  echo json_encode($message);
          die();
		else:
	    $message = array();
	    global $wpdb;
	    $userid = get_current_user_id();
	    $miraculous_theme_data = '';
        if (function_exists('fw_get_db_settings_option')):  
          $miraculous_theme_data = fw_get_db_settings_option();     
        endif; 
        $pricing_plan_page = '';
        if(!empty($miraculous_theme_data['user_pricing_plan_page'])):
            $pricing_plan_page = get_the_permalink( $miraculous_theme_data['user_pricing_plan_page'] );
        endif;
       
        if($userid == 0){
            $message = array('status' => 'false', 'msg' => 'You need to login.', 'plan_page' => '');
	        echo json_encode($message);
	        die();
        }

	    if( isset($_POST['musicid']) && $userid ){

	    	$music_type = get_post_meta($_POST['musicid'], 'fw_option:music_type', true);

	    	$songs = array();

	    	$songs[] = $_POST['musicid'];
	    	$mpurl = get_post_meta($_POST['musicid'], 'fw_option:mp3_full_songs', true);
	    	
	    	if(empty($mpurl)):
	    	    $mpurl = get_post_meta($_POST['musicid'], 'fw_option:music_extranal_url', true);
	        endif;
    		$title = get_the_title( $_POST['musicid'] );
    		$mp3url = '';
    		if($mpurl) {
    			$mp3url = $mpurl['url'];
    		}

	    	if($music_type == 'free'){
				
	    		$key = 'free_downloaded_songs_by_user_'.$userid;
				
	    		$music_id = get_user_meta($userid, $key, true);

		    	if( $music_id ) {

		        	if( in_array($_POST['musicid'], $music_id) ) {

    		          	$message['status'] = esc_html__('success','miraculous');
                        $message['msg'] = esc_html__('Already downloaded','miraculous');
    		          	$message['mp3_uri'] = $mp3url;
    		          	$message['mp3_name'] = $title;

		        	}else{

			          	$new_arr = array_merge($music_id, $songs);

			          	update_user_meta($userid, $key, $new_arr);

			          	$message['status'] = esc_html__('success','miraculous');

			          	$message['msg'] = esc_html__('downloaded successfully','miraculous');
			          	$message['mp3_uri'] = $mp3url;
		          		$message['mp3_name'] = $title;
                        update_post_meta($_POST['musicid'],'song_dowenload_counter',$counte);
		        	}

		      	}else{

			        update_user_meta($userid, $key, $songs);

			        $message['status'] = esc_html__('success','miraculous');
                    $message['msg'] = esc_html__('downloaded successfully','miraculous');
			        $message['mp3_uri'] = $mp3url;
		          	$message['mp3_name'] = $title;
		          	update_post_meta($_POST['musicid'],'song_dowenload_counter',$counte);

		      	}
				
				
	    	}else{
	    		$pmt_tbl = $wpdb->prefix . 'ms_payments'; 
	    		$query = $wpdb->get_row( "SELECT * FROM `$pmt_tbl` WHERE user_id = $userid AND expiretime > '$today' AND remains_download > 0" );
	    		if(!empty($query)){
	    			$key = 'premium_downloaded_songs_by_user_'.$userid;
		    		$music_id = get_user_meta($userid, $key, true);

			    	if( $music_id ) {

			        	if( in_array($_POST['musicid'], $music_id) ) {

			          	$message['status'] = esc_html__('success','miraculous');
                        $message['msg'] = esc_html__('Already downloaded','miraculous');
			          	$message['mp3_uri'] = $mp3url;
		          		$message['mp3_name'] = $title;

			        	}else{

				          	$new_arr = array_merge($music_id, $songs);

				          	update_user_meta($userid, $key, $new_arr);

				          	$message['status'] = esc_html__('success','miraculous');

				          	$message['msg'] = esc_html__('downloaded successfully','miraculous');
				          	$message['mp3_uri'] = $mp3url;
		          			$message['mp3_name'] = $title;

	          		      	$wpdb->update( 

	          	            	$pmt_tbl, 

	          		            array( 

	          		              'remains_download' => $query->remains_download-1

	          		            ), 

	          	            	array( 'ID' => $query->id ), 

	          		            array( 

	          		              '%d'

	          		            ), 

	          	            	array( '%d' ) 

	          	          	);
	          	          	update_post_meta($_POST['musicid'],'song_dowenload_counter',$counte);

			        	}

			      	}else{

				        update_user_meta($userid, $key, $songs);

				        $message['status'] = esc_html__('success','miraculous');

				        $message['msg'] = esc_html__('downloaded successfully','miraculous');
				        $message['mp3_uri'] = $mp3url;
		          		$message['mp3_name'] = $title;

	        	      	$wpdb->update( 

	                    	$pmt_tbl, 

	        	            array( 

	        	              'remains_download' => $query->remains_download-1

	        	            ), 

	                    	array( 'ID' => $query->id ), 

	        	            array( 

	        	              '%d'

	        	            ), 

	                    	array( '%d' ) 

	                  	);
	                  	update_post_meta($_POST['musicid'],'song_dowenload_counter',$counte);

			      	}

	    		}else{
	    			$message['status'] = esc_html__('false','miraculous');

			        $message['msg'] = esc_html__('You need to purchase plan for download.','miraculous');
			        $message['plan_page'] = $pricing_plan_page;
	    		}
	    	}

	      	echo json_encode($message);

	      	die();
	        
	    }

	    $message = array('status' => 'false', 'msg' => 'You need to login or need to purchase plan.', 'plan_page' => $pricing_plan_page);

	    echo json_encode($message);

	    die();
		
	 endif;
	 
	 
    }

	public function miraculous_remove_from_premium_songs_list(){

		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['songid']) && $userid) {

	    	$songs = array();

	    	$songs[] = $_POST['songid'];

	    	$music_id = get_user_meta($userid, 'premium_downloaded_songs_by_user_'.$userid, true);

	    	if( $music_id ) {

	      		if( in_array($_POST['songid'], $music_id) ) {

	        		$key = array_search($_POST['songid'], $music_id); 

                    unset($music_id[$key]);

	        		$new_arr = array_values($music_id);

	        		update_user_meta($userid, 'premium_downloaded_songs_by_user_'.$userid, $new_arr);

                    $message['status'] = esc_html__('success','miraculous');

	        		$message['msg'] = esc_html__('Removed successfully','miraculous');

	      		}

	    	}

           echo json_encode($message);
           die();

		}

        $message['status'] = esc_html__('error','miraculous');

		$message['msg'] = esc_html__('You need to login.','miraculous');

		echo json_encode($message);

		die();

	}

	public function miraculous_remove_from_free_songs_list(){

		$message = array();
        $userid = get_current_user_id();
        if (isset($_POST['songid']) && $userid) {

	    	$songs = array();
            $songs[] = $_POST['songid'];
            $music_id = get_user_meta($userid, 'free_downloaded_songs_by_user_'.$userid, true);

            if( $music_id ) {

	      		if( in_array($_POST['songid'], $music_id) ) {

	        		$key = array_search($_POST['songid'], $music_id); 

                    unset($music_id[$key]);

	        		$new_arr = array_values($music_id);

	        		update_user_meta($userid, 'free_downloaded_songs_by_user_'.$userid, $new_arr);



	        		$message['status'] = esc_html__('success','miraculous');

	        		$message['msg'] = esc_html__('Removed successfully','miraculous');

	      		}

	    	}

          echo json_encode($message);
          die();

		}

        $message['status'] = 'error';
        $message['msg'] = 'You need to login.';
        echo json_encode($message);
        die();

	}

	public function miraculous_remove_from_user_playlist_songs_list(){

		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['songid']) && isset($_POST['playlist']) && $userid) {

	    	$songs = array();
            $songs[] = $_POST['songid'];
	    	$playlist_key = 'miraculous_playlist_'.$userid.'_'.$_POST['playlist']; 

	    	$music_id = get_user_meta($userid, $playlist_key, true);



	    	if( $music_id ) {

	      		if( in_array($_POST['songid'], $music_id) ) {

	        		$key = array_search($_POST['songid'], $music_id); 



	        		unset($music_id[$key]);

	        		$new_arr = array_values($music_id);

	        		update_user_meta($userid, $playlist_key, $new_arr);



	        		$message['status'] = 'success';

	        		$message['msg'] = 'Removed successfully';

	      		}

	    	}



	    	echo json_encode($message);

	    	die();

		}



		$message['status'] = esc_html__('error','miraculous');

		$message['msg'] = esc_html__('You need to login','miraculous');

		echo json_encode($message);

		die();

	}

	function miraculous_add_to_queue_action(){

		$return_arr = array('status' => 'false', 'msg' => 'Not have music');
		
		
		if( isset($_POST['musicid']) && isset($_POST['musictype']) ){
		    
			$attach_meta = array();
			$queue_arr = array();
			
			
            $album = esc_html__('album','miraculous');
			if($_POST['musictype'] == $album){
				$ms_album_post_meta_option = '';
				$artists_name = array();
				if( function_exists('fw_get_db_post_option') ):
					$ms_album_post_meta_option = fw_get_db_post_option($_POST['musicid']);
			    endif;
		        if($ms_album_post_meta_option['album_artists']):
		    		foreach ($ms_album_post_meta_option['album_artists'] as $artists_id):
		    			$artists_name[] = get_the_title($artists_id);
		    		endforeach; 
		    	endif;
			    if(!empty($ms_album_post_meta_option['album_songs'])){

			    	foreach ($ms_album_post_meta_option['album_songs'] as $music_id) {
			    		$mpurl = get_post_meta($music_id, 'fw_option:mp3_full_songs', true);
			    		$title = get_the_title( $music_id );
			    		if(function_exists( 'fw_get_db_post_option' )):	
			    		    
                        $miraclous_post_data = fw_get_db_post_option($music_id); 
                        endif;
        				if(!empty($mpurl['url'])):
        					$mp3url = $mpurl['url'];
        				else:
        				$mp3url = '';
        				if(!empty($miraclous_post_data['music_extranal_url'])):
        				  $mp3url = $miraclous_post_data['music_extranal_url'];
        				endif;
        				endif;
			    		$image_uri = get_the_post_thumbnail_url ( $music_id );
			    		$artists = implode(', ', $artists_name);
                        $share_uri = get_the_permalink($music_id);
			    		$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists, 'mp3url' => $mp3url, 'mid' => $music_id, 'share_uri' => $share_uri); 

			    	}
			    }
			    if(!empty($queue_arr)){
			    	echo json_encode($queue_arr);
			    	die();
			    }else{
			    	echo json_encode($return_arr);
			    	die();
			    }
			}
			
			$radio = esc_html__('radio','miraculous');
			if($_POST['musictype'] == $radio){
				$ms_album_post_meta_option = '';
				$artists_name = array();
				if( function_exists('fw_get_db_post_option') ):
					$ms_album_post_meta_option = fw_get_db_post_option($_POST['musicid']);
			    endif;
		        if($ms_album_post_meta_option['radio_artists']):
		    		foreach ($ms_album_post_meta_option['radio_artists'] as $artists_id):
		    			$artists_name[] = get_the_title($artists_id);
		    		endforeach; 
		    	endif;
			    if(!empty($ms_album_post_meta_option['radio_songs'])){

			    	foreach ($ms_album_post_meta_option['radio_songs'] as $music_id) {
			    		$mpurl = get_post_meta($music_id, 'fw_option:mp3_full_songs', true);
			    		$title = get_the_title( $music_id );
			    		if(function_exists( 'fw_get_db_post_option' )):
			    		    
                        $miraclous_post_data = fw_get_db_post_option($music_id); 
                        endif;
        				if(!empty($mpurl['url'])):
        					$mp3url = $mpurl['url'];
        				else:
        				   $mp3url = '';
        				   if(!empty($miraclous_post_data['music_extranal_url'])):
        				      $mp3url = $miraclous_post_data['music_extranal_url'];
        				   endif;
        				endif;
			    		$image_uri = get_the_post_thumbnail_url ( $music_id );
			    		$artists = implode(', ', $artists_name);

			    		$share_uri = get_the_permalink($music_id);
			    		$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists, 'mp3url' => $mp3url, 'mid' => $music_id, 'share_uri' => $share_uri);

			    	}
			    }
			    if(!empty($queue_arr)){
			    	echo json_encode($queue_arr);
			    	die();
			    }else{
			    	echo json_encode($return_arr);
			    	die();
			    }
			}
            $artist = esc_html__('artist','miraculous');
			if($_POST['musictype'] == $artist){
				$ms_artist_post_meta_option = '';
				if( function_exists('fw_get_db_post_option') ):
				   $ms_artist_post_meta_option = fw_get_db_post_option();
				endif;
				$m_args = array('post_type' => 'ms-music', 
				                'numberposts' => -1);
				$artists = $_POST['musicid'];
				$music_posts = get_posts($m_args);
				$art = false;
				$i = 1;
				if(!empty($music_posts)){
					foreach ($music_posts as $music_post) {
						$artists_ids = get_post_meta($music_post->ID, 'fw_option:music_artists', true);
						if( $artists_ids && in_array($artists, $artists_ids) ){
							$mpurl = get_post_meta($music_post->ID, 'fw_option:mp3_full_songs', true);
						if(function_exists( 'fw_get_db_post_option' )):	
                            $miraclous_post_data = fw_get_db_post_option($music_post->ID); 
                        endif;
        				if(!empty($mpurl['url'])):
        					$mp3url = $mpurl['url'];
        				else:
        				   $mp3url = '';
        				   if(!empty($miraclous_post_data['music_extranal_url'])):
        				      $mp3url = $miraclous_post_data['music_extranal_url'];
        				   endif;
        				endif;
							$image_uri = get_the_post_thumbnail_url ( $music_post->ID );
							$title = get_the_title($music_post->ID);
							$artists_name = array();
							foreach ($artists_ids as $artists_id) {
							    $artists_name[] = get_the_title($artists_id);
							}
							$artists_n = implode(', ', $artists_name);
							$share_uri = get_the_permalink($music_post->ID);

							$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $music_post->ID, 'share_uri' => $share_uri); 
						}
					}
					if(!empty($queue_arr)){
						echo json_encode($queue_arr);
						die();
					}else{
						echo json_encode($return_arr);
						die();
					}
				}
			}
            $music = esc_html__('music','miraculous');
			if($_POST['musictype'] == $music){
				$mpurl = get_post_meta($_POST['musicid'], 'fw_option:mp3_full_songs', true);
			    if(function_exists( 'fw_get_db_post_option' )):	
                    $miraclous_post_data = fw_get_db_post_option($_POST['musicid']); 
                endif;
				if(!empty($mpurl['url'])):
					$mp3url = $mpurl['url'];
				else:
				   $mp3url = '';
				   if(!empty($miraclous_post_data['music_extranal_url'])):
				      $mp3url = $miraclous_post_data['music_extranal_url'];
				   endif;
				endif;
				$artists_ids = get_post_meta($_POST['musicid'], 'fw_option:music_artists', true);
				$artists_name = array();
				if($artists_ids){
					foreach ($artists_ids as $artists_id) {
					    $artists_name[] = get_the_title($artists_id);
					}
				}
				$image_uri = get_the_post_thumbnail_url ( $_POST['musicid'] );
				$title = get_the_title($_POST['musicid']);
				$artists_n = implode(', ', $artists_name);
				$share_uri = get_the_permalink($_POST['musicid']);
				
				$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $_POST['musicid'], 'share_uri' => $share_uri); 

				if(!empty($queue_arr)){
					echo json_encode($queue_arr);
					die();
				}else{
					echo json_encode($return_arr);
					die();
				}
			}

		}
		echo json_encode($return_arr);
		die();
		
		
	}

	function miraculous_play_all_music_action(){
		$return_arr = array('status' => 'false', 'msg' => 'Something went wrong.');
		$userid = get_current_user_id();
		if( isset($_POST['musicid']) && isset($_POST['musictype']) ){
			$attach_meta = array();
			$queue_arr = array();
            $album = esc_html__('album','miraculous');
			if($_POST['musictype'] == $album){
				$ms_album_post_meta_option = '';
				$artists_name = array();
				if( function_exists('fw_get_db_post_option') ):
					$ms_album_post_meta_option = fw_get_db_post_option($_POST['musicid']);
			    endif;
		        if($ms_album_post_meta_option['album_artists']):
		    		foreach ($ms_album_post_meta_option['album_artists'] as $artists_id):
		    			$artists_name[] = get_the_title($artists_id);
		    		endforeach; 
		    	endif;
			    if(!empty($ms_album_post_meta_option['album_songs'])){
                    $m = 1;
			    	foreach ($ms_album_post_meta_option['album_songs'] as $music_id) {
			    	    
			    		$mpurl = get_post_meta($music_id, 'fw_option:mp3_full_songs', true);
			    		
			    		$title = get_the_title( $music_id );
			    		if(function_exists( 'fw_get_db_post_option' )):	
                            $miraclous_post_data = fw_get_db_post_option($music_id); 
                        endif;
        				if(!empty($mpurl['url'])):
        					$mp3url = $mpurl['url'];
        				else: 
        				   $mp3url = '';
        				   if(!empty($miraclous_post_data['music_extranal_url'])):
        				      $mp3url = $miraclous_post_data['music_extranal_url'];
        				   endif;
        				endif;
			    		$image_uri = get_the_post_thumbnail_url ( $music_id );
			    		$artists = implode(', ', $artists_name);
                        $share_uri = get_the_permalink($music_id);
			    		$queue_arr[] = array('status' => 'success', 'image' => esc_url($image_uri), 'song_name' => $title, 'artists' => $artists, 'mp3url' => esc_url($mp3url), 'mid' => $music_id, 'share_uri' => $share_uri); 
			    		$songs = array();
			    		$songs[] = $music_id;

			    		if($userid && $m == 1){
			    			$hsmusic_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);
			    			if( $hsmusic_id ) {

			    				if( in_array($music_id, $hsmusic_id) ) {

			    			  	}else{
			    			        $new_arr = array_merge($hsmusic_id, $songs);
			    			        update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);
			    			  	}

			    			}else{
			    				update_user_meta($userid, 'history_songs_list_user_'.$userid, $songs);
			    			}
	
			    		}
                        $m++;
			    	}
			    }
			    if(!empty($queue_arr)){
			    	echo json_encode($queue_arr);
			    	die();
			    }else{
			    	echo json_encode($return_arr);
			    	die();
			    }
			}
            $radio = esc_html__('radio','miraculous');
			if($_POST['musictype'] == $radio){
				$ms_album_post_meta_option = '';
				$artists_name = array();
				if( function_exists('fw_get_db_post_option') ):
					$ms_album_post_meta_option = fw_get_db_post_option($_POST['musicid']);
			    endif;
		        if($ms_album_post_meta_option['radio_artists']):
		    		foreach ($ms_album_post_meta_option['radio_artists'] as $artists_id):
		    			$artists_name[] = get_the_title($artists_id);
		    		endforeach; 
		    	endif;
			    if(!empty($ms_album_post_meta_option['radio_songs'])){
                    $m = 1;
			    	foreach ($ms_album_post_meta_option['radio_songs'] as $music_id) {
			    		$mpurl = get_post_meta($music_id, 'fw_option:mp3_full_songs', true);
			    		$title = get_the_title( $music_id );
    			    	if(function_exists( 'fw_get_db_post_option' )):	
                         $miraclous_post_data = fw_get_db_post_option($music_id); 
                         endif;
        				if(!empty($mpurl['url'])):
        					$mp3url = $mpurl['url'];
        				else:
        				   $mp3url = '';
        				   if(!empty($miraclous_post_data['music_extranal_url'])):
        				      $mp3url = $miraclous_post_data['music_extranal_url'];
        				   endif;
        				endif;
			    		$image_uri = get_the_post_thumbnail_url ( $music_id );
			    		$artists = implode(', ', $artists_name);

			    		$share_uri = get_the_permalink($music_id);
			    		$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists, 'mp3url' => $mp3url, 'mid' => $music_id, 'share_uri' => $share_uri); 
			    		$songs = array();
			    		$songs[] = $music_id;

			    		if($userid && $m == 1){
			    			$hsmusic_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);
			    			if( $hsmusic_id ) {

			    				if( in_array($music_id, $hsmusic_id) ) {

			    			  	}else{
			    			        $new_arr = array_merge($hsmusic_id, $songs);
			    			        update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);
			    			  	}

			    			}else{
			    				update_user_meta($userid, 'history_songs_list_user_'.$userid, $songs);
			    			}
			    			
			    		}
                        $m++;
			    	}
			    }
			    if(!empty($queue_arr)){
			    	echo json_encode($queue_arr);
			    	die();
			    }else{
			    	echo json_encode($return_arr);
			    	die();
			    }
			}
            $artist = esc_html__('artist','miraculous');
			if($_POST['musictype'] == $artist){
				$ms_artist_post_meta_option = '';
				if( function_exists('fw_get_db_post_option') ):
				   $ms_artist_post_meta_option = fw_get_db_post_option();
				endif;
				$m_args = array('post_type' => 'ms-music', 
				                'numberposts' => -1);
				$artists = $_POST['musicid'];
				$music_posts = get_posts($m_args);
				$art = false;
				$i = 1;
				if(!empty($music_posts)){ $m = 1;
					foreach ($music_posts as $music_post) {
						$artists_ids = get_post_meta($music_post->ID, 'fw_option:music_artists', true);
						if( $artists_ids && in_array($artists, $artists_ids) ){
							$mpurl = get_post_meta($music_post->ID, 'fw_option:mp3_full_songs', true);
							if(function_exists( 'fw_get_db_post_option' )):	
                               $miraclous_post_data = fw_get_db_post_option($music_post->ID); 
                            endif;
            				if(!empty($mpurl['url'])):
            					$mp3url = $mpurl['url'];
            				else:
            				$mp3url = '';
            			      if(!empty($miraclous_post_data['music_extranal_url'])):
            			      $mp3url = $miraclous_post_data['music_extranal_url'];
            				 endif;
            				endif;
							$image_uri = get_the_post_thumbnail_url ( $music_post->ID );
							$title = get_the_title($music_post->ID);
							$artists_name = array();
							foreach ($artists_ids as $artists_id) {
							    $artists_name[] = get_the_title($artists_id);
							}
							$artists_n = implode(', ', $artists_name);
							$share_uri = get_the_permalink($music_post->ID);

							$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $music_post->ID, 'share_uri' => $share_uri); 
							$songs = array();
							$songs[] = $music_post->ID;

							if($userid && $m == 1){
								$hsmusic_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);
								if( $hsmusic_id ) {

									if( in_array($music_post->ID, $hsmusic_id) ) {

								  	}else{
								        $new_arr = array_merge($hsmusic_id, $songs);
								        update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);
								  	}

								}else{
									update_user_meta($userid, 'history_songs_list_user_'.$userid, $songs);
								}
								
							}
						}
						$m++;
					}
					if(!empty($queue_arr)){
						echo json_encode($queue_arr);
						die();
					}else{
						echo json_encode($return_arr);
						die();
					}
				}
			}
            $music = esc_html__('music','miraculous');
			if($_POST['musictype'] == $music){
				$mpurl = get_post_meta($_POST['musicid'], 'fw_option:mp3_full_songs', true);
				if(function_exists( 'fw_get_db_post_option' )):	
                    $miraclous_post_data = fw_get_db_post_option($_POST['musicid']); 
                endif;
				if(!empty($mpurl['url'])):
					$mp3url = $mpurl['url'];
				else:
				   $mp3url = '';
				   if(!empty($miraclous_post_data['music_extranal_url'])):
				      $mp3url = $miraclous_post_data['music_extranal_url'];
				   endif;
				endif;
				$artists_ids = get_post_meta($_POST['musicid'], 'fw_option:music_artists', true);
				$artists_name = array();
				if($artists_ids){
					foreach ($artists_ids as $artists_id) {
					    $artists_name[] = get_the_title($artists_id);
					}
				}
				$image_uri = get_the_post_thumbnail_url ( $_POST['musicid'] );
				$title = get_the_title($_POST['musicid']);
				$artists_n = implode(', ', $artists_name);
				$share_uri = get_the_permalink($_POST['musicid']);
				$queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $_POST['musicid'], 'share_uri' => $share_uri); 

				$songs = array();
				$songs[] = $_POST['musicid'];

				if($userid){
					$hsmusic_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);
					if( $hsmusic_id ) {

						if( in_array($_POST['musicid'], $hsmusic_id) ) {

					  	}else{
					        $new_arr = array_merge($hsmusic_id, $songs);
					        update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);
					  	}

					}else{
						update_user_meta($userid, 'history_songs_list_user_'.$userid, $songs);
					}
				}

				if(!empty($queue_arr)){
					echo json_encode($queue_arr);
					die();
				}else{
					echo json_encode($return_arr);
					die();
				}
			}

		}
		echo json_encode($return_arr);
		die();
	}
	
	public function miraculous_play_user_playlist(){
	    $return_arr = array('status' => 'false', 'msg' => 'Playlist is empty.');
		$userid = get_current_user_id();
		
		if (isset($_POST['playlist']) && $userid) {
            $queue_arr = array();
            $ms_favourite = esc_html__('ms_favourite','miraculous');
            if($_POST['playlist'] == $ms_favourite){
                $playlist_key = 'favourites_songs_lists'.$userid;
            }else{
                $playlist_key = 'miraculous_playlist_'.$userid.'_'.$_POST['playlist']; 
            }
            
            $musicsids = get_user_meta($userid, $playlist_key, true);
            if($musicsids){
                $sg_args = array('post_type' => 'ms-music',
                                'post__in' => $musicsids,
                            );
                $music_posts = new WP_Query( $sg_args );
                if($music_posts->have_posts()): 
                    while ( $music_posts->have_posts() ) : $music_posts->the_post();
                    
					$miraculous_meta_data = '';
					if (function_exists('fw_get_db_post_option')): 
						$miraculous_meta_data = fw_get_db_post_option(get_the_id());   
					endif; 
					if(!empty($miraculous_meta_data['music_extranal_url'])):
					  $mpurl = $miraculous_meta_data['music_extranal_url'];
					else:
					  $mpurl = $miraculous_meta_data['mp3_full_songs']['url'];
					endif;
					
					if($mpurl) {
                        $mp3url = $mpurl;
                    }
                    $artists_ids = get_post_meta(get_the_id(), 'fw_option:music_artists', true);
				    $artists_name = array();
				    if($artists_ids){
					    foreach ($artists_ids as $artists_id) {
					        $artists_name[] = get_the_title($artists_id);
					    }
				    }
                    $image_uri = get_the_post_thumbnail_url ();
                    $title = get_the_title();
				    $artists_n = implode(', ', $artists_name);
				    $share_uri = get_the_permalink();
				    $queue_arr[] = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $_POST['musicid'], 'share_uri' => $share_uri); 
				    
                    endwhile;
                    
                endif;
                
            }
            if(!empty($queue_arr)){
				echo json_encode($queue_arr);
				die();
			}else{
				echo json_encode($return_arr);
				die();
			}
	    	echo json_encode($message);
	    	die();

		}
	    echo json_encode($message);
	    die();
	}

	public function miraculous_user_queue_data_action(){
		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['musiclist']) && $userid) {

	    	$queue_data = 'miraculous_queue_data_'.$userid; 
            
            $rst = update_user_meta($userid, $queue_data, $_POST['musiclist']);
            if($rst){
                $message['status'] = 'success';
		        $message['msg'] = 'Saved Successfully';
            }else{
                $message['status'] = 'false';
		        $message['msg'] = 'Something went wrong.';
            }
	    	echo json_encode($message);
	    	die();

		}

		$message['status'] = esc_html__('false','miraculous');
		$message['msg'] = esc_html__('Something went wrong.','miraculous');

		echo json_encode($message);

		die();
	}

	public function miraculous_user_load_queue_data_action(){
		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['musiclist'])) {

	    	$queue_data = 'miraculous_queue_data_'.$userid; 
            
            $rst = get_user_meta($userid, $queue_data, true);
            if($rst){
                $message['status'] = 'success';
		        $message['msg'] = 'Added Successfully';
		        $message['queue_data'] = $rst;
		        echo json_encode($message);
    			die();
            }else{
                $sg_args = array('post_type' => 'ms-music',
                                 'orderby'   => 'rand',
                    			 'posts_per_page' => 1, 
                                 );
    		    $queue_arr = array();
                $music_posts = new WP_Query( $sg_args );
                if($music_posts->have_posts()): 
                    while ( $music_posts->have_posts() ) : $music_posts->the_post();
                    $miraculous_meta_data = '';
					if(function_exists('fw_get_db_post_option')): 
						$miraculous_meta_data = fw_get_db_post_option(get_the_ID());   
					endif; 
					if(!empty($miraculous_meta_data['music_extranal_url'])):
					  $mpurl = $miraculous_meta_data['music_extranal_url'];
					else:
					  $mpurl = $miraculous_meta_data['mp3_full_songs']['url'];
					endif;
					
                    if($mpurl) {
                        $mp3url = $mpurl;
                    }
                    $artists_ids = get_post_meta(get_the_id(), 'fw_option:music_artists', true);
    			    $artists_name = array();
    			    if($artists_ids){
    				    foreach ($artists_ids as $artists_id) {
    				        $artists_name[] = get_the_title($artists_id);
    				    }
    			    }
                    $image_uri = get_the_post_thumbnail_url();
                    $title = get_the_title();
                    $musicid = get_the_id();
    			    $artists_n = implode(', ', $artists_name);
    			    $share_uri = get_the_permalink();
    			    $queue_arr = array('status' => 'default', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $musicid, 'share_uri' => $share_uri); 
    			    
                    endwhile;
                    
                endif;

                if(!empty($queue_arr)){
    				echo json_encode($queue_arr);
    				die();
    			}
            }

		}

		$message['status'] = esc_html__('false','miraculous');
		$message['msg'] = esc_html__('Something went wrong.','miraculous');

		echo json_encode($message);

		die();
	}

	public function miraculous_play_single_music_action(){
		$return_arr = array('status' => 'false', 'msg' => 'Something went wrong.');
		$userid = get_current_user_id();
		$queue_arr = array();

		if(isset($_POST['musicid']) && $_POST['musicid'] != ''){
			
			$miraculous_meta_data = '';
			if (function_exists('fw_get_db_post_option')): 
				$miraculous_meta_data = fw_get_db_post_option($_POST['musicid']);   
			endif; 
			if(!empty($miraculous_meta_data['music_extranal_url'])):
			  $mpurl = $miraculous_meta_data['music_extranal_url'];
			else:
			  $mpurl = $miraculous_meta_data['mp3_full_songs']['url'];
			endif;
			
			if($mpurl) {
				$mp3url = $mpurl;
			}
			$artists_ids = get_post_meta($_POST['musicid'], 'fw_option:music_artists', true);
			$artists_name = array();
			if($artists_ids){
				foreach ($artists_ids as $artists_id) {
				    $artists_name[] = get_the_title($artists_id);
				}
			}
			$image_uri = get_the_post_thumbnail_url ( $_POST['musicid'] );
			$title = get_the_title($_POST['musicid']);
			$artists_n = implode(', ', $artists_name);
			$share_uri = get_the_permalink($_POST['musicid']);
			$queue_arr = array('status' => 'success', 'image' => $image_uri, 'song_name' => $title, 'artists' => $artists_n, 'mp3url' => $mp3url, 'mid' => $_POST['musicid'], 'share_uri' => $share_uri); 

			$songs = array();
			$songs[] = $_POST['musicid'];

			if($userid){
				$hsmusic_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);
				if( $hsmusic_id ) {

					if( in_array($_POST['musicid'], $hsmusic_id) ) {

				  	}else{
				        $new_arr = array_merge($hsmusic_id, $songs);
				        update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);
				  	}

				}else{
					update_user_meta($userid, 'history_songs_list_user_'.$userid, $songs);
				}
			}

			if(!empty($queue_arr)){
				echo json_encode($queue_arr);
				die();
			}else{
				echo json_encode($return_arr);
				die();
			}
		}

		echo json_encode($return_arr);
		die();

	}

	public function miraculous_remove_history_music_action(){
		$message = array();

		$userid = get_current_user_id();

		if (isset($_POST['songid']) && $userid) {

	    	$songs = array();

	    	$songs[] = $_POST['songid'];

	    	$music_id = get_user_meta($userid, 'history_songs_list_user_'.$userid, true);

	    	if( $music_id ) {

	      		if( in_array($_POST['songid'], $music_id) ) {

	        		$key = array_search($_POST['songid'], $music_id); 

	        		unset($music_id[$key]);

	        		$new_arr = array_values($music_id);

	        		update_user_meta($userid, 'history_songs_list_user_'.$userid, $new_arr);

	        		$message['status'] = esc_html__('success','miraculous');

	                $message['msg'] = esc_html__('Removed successfully','miraculous');

	      		}

	    	}

	    	echo json_encode($message);
	    	die();

		}

		$message['status'] = esc_html__('error','miraculous');

		$message['msg'] = esc_html__('Something went wrong.','miraculous');

		echo json_encode($message);

		die();
	}


   public function miraculous_freeplane_optionajax(){
    
    $first_name = '';
    if(isset($_POST['first_name'])):
      $first_name = $_POST['first_name'];
    endif;
   $last_name = '';
    if(isset($_POST['last_name'])):
      $last_name = $_POST['last_name'];
    endif;
   $payer_email = '';
    if(isset($_POST['payer_email'])):
      $payer_email = $_POST['payer_email'];
    endif;
   $user_id = '';
    if(isset($_POST['user_id'])):
      $user_id = $_POST['user_id'];
    endif;
   $item_number = '';
    if(isset($_POST['item_number'])):
      $item_number = $_POST['item_number'];
    endif;
    $item_name = '';
    if(isset($_POST['item_name'])):
      $item_name = $_POST['item_name'];
    endif;
    $payment_amount = esc_html__('Free','miraculous');
    $payment_status = esc_html__('Accept','miraculous');
    $txnid = esc_html__('Free','miraculous');
    $itemAmount = get_post_meta($_POST['item_number'], 'fw_option:plan_price', true);
    $plan_validity = get_post_meta($_POST['item_number'], 'fw_option:plan_validity', true);
    $monthly_download = get_post_meta($_POST['item_number'], 'fw_option:plan_monthly_downloads', true);
    $monthly_upload = get_post_meta($_POST['item_number'], 'fw_option:plan_monthly_upload', true) ? get_post_meta($_POST['item_number'], 'fw_option:plan_monthly_upload', true) : 50;
    global $wpdb;
	$tbl_pay = $wpdb->prefix. 'ms_payments';
	$m = $plan_validity;
	$data = array(
               "plan_name" => $item_name,
               "plan_number" => $item_number,
               "user_id" => $user_id,
               "plan_validity" => $plan_validity,
               "monthly_download" => $monthly_download,
               "monthly_upload" => $monthly_upload,
               "payment_status" => 'Accept',
               "payment_amount" => '0.0',
               "payment_currency" => 'USA',
               "txn_id" => 'Free',
               "receiver_email" => $payer_email,
               "receiver_email" => $payer_email
               );
       $wpdb->insert( 
			$tbl_pay, 
			array(
				'user_id' => $user_id, 
				'txnid' => $txnid, 
				'payment_amount' => $payment_amount,
				'payment_status' => $payment_status,
				'itemid' => $item_number,
				'monthly_download' => $monthly_download,
				'monthly_upload' => $monthly_upload,
				'createdtime' => date('Y-m-d H:i:s'),
				'expiretime' => date("Y-m-d H:i:s", strtotime("+$m months")),
				'remains_download' => $monthly_download,
				'remains_upload' => $monthly_upload,
				'extra_data' => json_encode($data),
			), 
			array(
				'%d', 
				'%s', 
				'%s',
				'%s',
				'%d',
				'%d',
				'%d',
				'%s',
				'%s',
				'%d', 
				'%d',
				'%s'
			) 
		);
 	 echo esc_html($wpdb->insert_id);
     wp_die(); 
    }
}

$Miraculous_Ajax = new Miraculous_Ajax_Call();

$Miraculous_Ajax->init();
?>