<?php if (!defined('FW')) die('Forbidden');

$sg_label = $mpurl = '';
if(!empty($atts['user_music_label'])):
    $sg_label = $atts['user_music_label'];
endif;
$sg_type = '';
if(!empty($atts['user_music_type'])):
    $sg_type = $atts['user_music_type'];
endif;
$sg_number = 12;
if(!empty($atts['user_music_number'])):
    $sg_number = $atts['user_music_number'];
endif;
$miraculous_theme_data = '';
if (function_exists('fw_get_db_settings_option')):  
    $miraculous_theme_data = fw_get_db_settings_option();     
endif; 
$currency = '';
if(!empty($miraculous_theme_data['paypal_currency']) && function_exists('miraculous_currency_symbol')):
    $currency = miraculous_currency_symbol( $miraculous_theme_data['paypal_currency'] );
endif;
$list_type = 'music';
$close_icone = get_template_directory_uri().'/assets/images/svg/close.svg';
$user_id = get_current_user_id();
$lang_data = get_option('language_filter_ids_'.$user_id);
$fav_music_ids = '';
if($user_id){
    $fav_music_ids = get_user_meta($user_id, 'favourites_songs_lists'.$user_id, true);
}

$music_ids = '';
if($sg_type == 'free'):
        $music_ids = get_user_meta($user_id, 'free_downloaded_songs_by_user_'.$user_id, true);
    else:
        $music_ids = get_user_meta($user_id, 'premium_downloaded_songs_by_user_'.$user_id, true);
endif;

if( is_user_logged_in() && $lang_data ){

    $sg_args = array('post_type' => 'ms-music',
                'posts_per_page' => $sg_number,
                'post__in' => $music_ids,
                'tax_query' => array(
                        array(
                            'taxonomy' => 'language',
                            'terms' => $lang_data
                        )
                    )
                );
}elseif ( isset($_COOKIE['lang_filter']) ) {
    $lang_data = explode(',', $_COOKIE['lang_filter']);

    $sg_args = array('post_type' => 'ms-music',
                'posts_per_page' => $sg_number,
                'post__in' => $music_ids,
                'tax_query' => array(
                        array(
                            'taxonomy' => 'language',
                            'terms' => $lang_data
                        )
                    )
                );
}else{
    $sg_args = array('post_type' => 'ms-music',
                'posts_per_page' => $sg_number,
                'post__in' => $music_ids,
                );
}

// the query
$music_posts = new WP_Query( $sg_args );

if( $music_posts->have_posts() && $user_id && $music_ids): ?>
    <!-- Free Download Css Start -->
    <div class="ms_free_download ms_purchase_wrapper">
        <div class="ms_heading">
            <h1><?php echo esc_html( $sg_label ); ?></h1>
        </div>
        <div class="album_inner_list">
            <div class="album_list_wrapper">
                <ul class="album_list_name">
                    <li><?php esc_html_e('#', 'miraculous'); ?></li>
                    <li><?php esc_html_e('Song Title', 'miraculous'); ?></li>
                    <li><?php esc_html_e('Artist', 'miraculous'); ?></li>
                    <li class="text-center"><?php esc_html_e('price', 'miraculous'); ?></li>
                    <li class="text-center"><?php esc_html_e('Duration', 'miraculous'); ?></li>
                    <li class="text-center"><?php esc_html_e('More', 'miraculous') ?></li>
                    <li class="text-center">
                        <?php esc_html_e('remove','miraculous');?></li>
                </ul>
                <?php $i=1; while ( $music_posts->have_posts() ) : $music_posts->the_post(); ?>
                        <ul class="ms_list_songs">
                            <li><a href="javascript:;"><span class="play_no"><?php echo (strlen($i) < 2) ? '0'.$i : $i; ?></span><span class="play_hover"></span></a></li>
                            <li><a href="javascript:;" data-musicid="<?php echo esc_attr(get_the_id()); ?>" class="play_single_music"><?php the_title(); ?></a></li>
                            <?php
                                $artists_name = array();
                                $music_price = '';
                                if(function_exists('fw_get_db_post_option')){
                                    $artists_ids = fw_get_db_post_option(get_the_id(), 'music_artists'); 
                                    foreach($artists_ids as $artists_id) {
                                        $artists_name[] = get_the_title($artists_id);
                                    } 
                                    
                                    $music_price_arr = fw_get_db_post_option(get_the_id(), 'music_type_options');
                                    if( !empty( $music_price_arr['premium']['single_music_price'] ) ){
                                        $music_price = $music_price_arr['premium']['single_music_price'];
                                    }
                                    
                                }
                            ?>
                            <li><a href="javascript:;" class="play_single_music"><?php echo implode(', ', $artists_name); ?></a></li>
                            <?php if($sg_type == 'free'): ?>
                                    <li class="text-center"><a href="javascript:;"><?php esc_html_e('Free', 'miraculous'); ?></a></li>
                                <?php else: ?>
                                    <li class="text-center"><a href="javascript:;"><?php printf( __('%s%s', 'miraculous'), $currency, $music_price ); ?></a></li>
                            <?php endif;
                                $music_extranal_url = get_post_meta(get_the_id(), 'fw_option:music_extranal_url', true);
                                if(!empty($music_extranal_url)):
                                    $mpurl = $music_extranal_url;
                                else:
                                    $mpurl = get_post_meta(get_the_id(), 'fw_option:mp3_full_songs', true);
                                endif;
                                $attach_meta = '';
                                if($mpurl) {
                                    $attach_meta = wp_get_attachment_metadata( $mpurl['attachment_id'] );
                                }
                                $fav_class = 'icon_fav';
                                if(!empty($fav_music_ids)){
                                    if( in_array(get_the_id(), $fav_music_ids) ) {
        			                    $fav_class = 'icon_fav_add';
        		      	            }
                                } ?>
                            <li class="text-center"><a href="javascript:;"><?php echo (isset($attach_meta['length_formatted'])) ? $attach_meta['length_formatted'] : "0.00"; ?></a></li>
                            <li class="text-center ms_more_icon"><a href="javascript:;"><span class="ms_icon1 ms_active_icon"></span></a>
                                <ul class="more_option">
                                    <li><a href="javascript:;" class="favourite_music" data-musicid="<?php esc_attr(get_the_id()); ?>"><span class="opt_icon"><span class="icon <?php echo esc_attr($fav_class); ?>"></span></span><?php esc_html_e('Favourites', 'miraculous'); ?></a></li>
                                    <li><a href="javascript:;" class="add_to_queue" data-musicid="<?php esc_attr_e(get_the_id()); ?>" data-musictype="<?php esc_attr_e($list_type); ?>"><span class="opt_icon"><span class="icon icon_queue"></span></span><?php esc_html_e('Add To Queue', 'miraculous'); ?></a></li>
                                    <li><a href="javascript:;" class="ms_download" data-msmusic="<?php esc_attr_e(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_dwn"></span></span><?php esc_html_e('Download Now', 'miraculous'); ?></a></li>
                                    <li><a href="javascript:;" class="ms_add_playlist" data-msmusic="<?php esc_attr_e(get_the_id()); ?>"><span class="opt_icon"><span class="icon icon_playlst"></span></span><?php esc_html_e('Add To Playlist', 'miraculous'); ?></a></li>
                                    <li><a href="javascript:;" class="ms_share_music" data-shareuri="<?php esc_attr_e(get_the_permalink()); ?>" data-sharename="<?php the_title_attribute(); ?>"><span class="opt_icon"><span class="icon icon_share"></span></span><?php esc_html_e('Share', 'miraculous'); ?></a></li>
                                </ul>
                            </li>
                            <li class="text-center">
                                <a href="javascript:;" class="remove_<?php echo esc_attr($sg_type); ?>_music" musicid="<?php echo esc_attr(get_the_id()); ?>">
                                <?php if(!empty($close_icone)): ?>
                                     <span class="ms_close">
                                        <img src="<?php echo esc_url($close_icone); ?>" alt="<?php echo esc_attr__('close icone','miraculous'); ?>">
                                     </span>
                                <?php endif; ?>  
                                </a>
                            </li>
                        </ul>
                <?php $i++; endwhile; ?>
            </div>
        </div>
    </div>
<?php endif; 
if(!$user_id): ?>
    <script>
        $(document).ready(function(){
           $("#myModal1").modal("show");
        });
    </script>
<?php endif;
?>
